FORMAT: 1A

# Advanced JSON Schema
The JSON body and JSON Schema for a request or response can be generated from
the attributes section MSON data structure. The generated schema can also be
overridden by providing an explicit schema, as you can see in the examples
below.

## API Blueprint
+ [Previous: JSON Schema](14.%20JSON%20Schema.md)
+ [This: Raw API Blueprint](https://raw.github.com/apiaryio/api-blueprint/master/examples/15.%20Advanced%20JSON%20Schema.md)

# Notes [/notes/{id}]

+ Parameters

    + id: abc123 (required) - Unique identifier for a note

## Get a note [GET]
Gets a single note by its unique identifier.

+ Response 200 (application/json)

    + Attributes

        + id: abc123
        + title: This is a note
        + content: This is the note content.
        + tags: todo, home (array[string])

## Update a note [PATCH]
Modify a note's data using its unique identifier. You can edit the `title`,
`content`, and `tags`.

+ Request (application/json)

    + Attributes

        + title: This is another note
        + content
        + tags: todo, work (array[string])

    + Schema

            {
                "type": "object",
                "description": "This is a custom schema!",
                "properties": {
                    "title": {
                        "type": "string"
                    },
                    "content": {
                        "type": "string"
                    },
                    "tags": {
                        "type": "array",
                        "items": {
                            "type": "string"
                        }
                    }
                },
                "additionalProperties": false
            }

+ Response 204
